from datetime import timedelta, datetime

import jwt

from config.settings import JWTToken
from controller.context_manager import context_user_data, context_user_data
from logger import logger
from schema.user import UserTokenData
from utils.exceptions import AuthException
import http

from fastapi import HTTPException




class JWTHandler:
    @staticmethod
    def create_access_token(to_encode: dict, expires_delta: timedelta = timedelta(minutes=30)):

        if expires_delta:
            expire = datetime.now() + expires_delta
        else:
            expire = datetime.now() + timedelta(
                minutes=int(JWTToken.access_token_expire_minutes)
            )
        to_encode.update({"exp": expire.timestamp()})
        encoded_jwt = jwt.encode(
            to_encode, JWTToken.secret, algorithm=JWTToken.algorithm
        )

        return encoded_jwt

    @staticmethod
    def decode_access_token(token: str):
        try:
            payload = jwt.decode(
                token, JWTToken.secret, algorithms=[JWTToken.algorithm]
            )
            
            
            context_user_data.set(UserTokenData(**payload))
            
        except jwt.ExpiredSignatureError:
            raise HTTPException(
                status_code=http.HTTPStatus.UNAUTHORIZED,
                detail={"message":"Token has expired", "status": False},
        
            )
        except Exception as e:
            logger.error(
                extra=context_user_data.get(),
                msg=f"Error while decoding access token: {e}",
            )
            raise HTTPException(
                status_code=401, detail={"message": "Invalid authentication credentials", "status": False }
            )
