from typing import Dict


def flatten_dict(d: Dict) -> Dict:
    items = []
    for k, v in d.items():
        if isinstance(v, dict):
            items.extend(flatten_dict(v).items())
        else:
            items.append((k, v))
    return dict(items)
