from enum import Enum
from uuid import UUID
from typing import Optional, List

from pydantic import BaseModel, validator, EmailStr, Json

from schema.base import DBBaseModel


class consignee_details(BaseModel):
    consignee_name: str
    consignee_phone: str
    consignee_email: str
    consignee_company: str
    consignee_address: str
    consignee_pincode: str
    consignee_city: str
    consignee_state: str
    consignee_country: str


class Pickup_details(BaseModel):
    pickup_name: str
    pickup_phone: str
    pickup_email: str
    pickup_company: str
    pickup_address: str
    pickup_pincode: str
    pickup_city: str
    pickup_state: str
    pickup_country: str
    pickup_location_code: str


class billing_details(BaseModel):
    billing_name: str
    billing_phone: str
    billing_company: str = ""
    billing_address: str
    billing_pincode: str
    billing_city: str
    billing_state: str
    billing_country: str
    billing_email: str
    billing_district: Optional[str] = None


class payment_details(BaseModel):
    total_amount: int = 0
    payment_mode: str = "COD"
    cod_charges: int = 0
    shipping_charges: int = 0
    tax_amount: int = 0
    discount: int = 0


class package_details(BaseModel):
    length: str
    breadth: str
    height: str
    weight: str
    box_id: Optional[str]


class invoice_details(BaseModel):
    invoice_number: str = ""
    invoice_date: str = ""
    invoice_amount: str = ""
    invoice_url: Optional[str] = ""
    eway_bill_number: Optional[str] = ""
    eway_expire_date: Optional[str] = ""
    eway_distance: Optional[str] = ""


class product(BaseModel):
    name: str
    unit_price: str
    quantity: int
    sku_code: str


class Shipment_create_model(
    consignee_details, Pickup_details, billing_details, payment_details, invoice_details
):
    order_id: str = ""
    order_type: str
    order_date: str
    shipment_mode: str = "surface"
    courier_partner: str = ""
    products: List[product]
    package_details: List[package_details]
