from enum import Enum
from uuid import UUID
from typing import Optional, Any, List

from pydantic import BaseModel, Json

from schema.base import DBBaseModel


class address(BaseModel):
    name: str
    phone: str
    company_name: str
    address: str
    pincode: str
    city: str
    state: str
    country: str
    email: str


class pickupAddress(address):
    location_code: str


class order_details(BaseModel):
    order_id: str
    order_type: str
    order_date: str
    shipment_mode: str = "surface"
    courier_partner: Optional[str] = None
    status: str = "New"
    awb_number: Optional[str] = None


class consignee_details(BaseModel):
    consignee_name: str
    consignee_phone: str
    consignee_company: str = ""
    consignee_address: str
    consignee_pincode: str
    consignee_district: str
    consignee_city: str
    consignee_state: str
    consignee_country: str
    consignee_email: str


class pickup_details(BaseModel):
    pickup_name: str
    pickup_phone: str
    pickup_company: str = ""
    pickup_address: str
    pickup_pincode: str
    pickup_district: str
    pickup_city: str
    pickup_state: str
    pickup_country: str
    pickup_email: str
    pickup_location_code: Optional[str] = ""


class billing_details(BaseModel):
    billing_name: str
    billing_phone: str
    billing_company: str = ""
    billing_address: str
    billing_pincode: str
    billing_district: str
    billing_city: str
    billing_state: str
    billing_country: str
    billing_email: str


class payment_details(BaseModel):
    total_amount: str = 0
    payment_mode: str = "prepaid"
    cod_charges: str = 0
    shipping_charges: str = 0
    tax_amount: str = 0
    discount: str = 0


class invoice_schema(BaseModel):
    invoice_number: str = ""
    invoice_date: str = ""
    invoice_amount: str = ""
    invoice_url: Optional[str] = ""
    eway_bill_number: Optional[str] = ""
    eway_expire_date: Optional[str] = ""
    eway_distance: Optional[str] = ""


class package_details(BaseModel):
    length: str
    breadth: str
    height: str
    weight: str
    box_id: Optional[str]


class product(BaseModel):
    name: str
    unit_price: str
    quantity: int
    sku_code: str


class Order_create_request_model(order_details):

    payment_details: payment_details
    products: List[product]
    package_details: List[package_details]
    pickup_details: pickupAddress
    billing_details: address
    consignee_details: address
    invoice_details: invoice_schema
    api_key: Optional[str] = None

    def create_db_entity(self):
        from model.order import Order

        dict_to_build_db_entity = self.model_dump()
        return Order(**dict_to_build_db_entity)


class Order_Model(
    order_details,
    consignee_details,
    pickup_details,
    billing_details,
    payment_details,
    DBBaseModel,
):
    products: List[product]
    invoice_details: Json


class order_id_model(BaseModel):
    order_id: str


class getAllOrders(BaseModel):
    pageNumber: int
    batchSize: int
    status: str = "All"
    type: str = "forward"
    search: str = ""
