from sqlalchemy import Column, String, JSON
from pydantic import ConfigDict

from sqlalchemy.orm import Session
from model.db import DBBaseClass, DBBase
from schema.user import UserModel, UserStatus, UserRole
from schema.order import Order_Model


class Order(DBBase, DBBaseClass):
    __tablename__ = "order"

    order_id = Column(String(255), nullable=False)
    order_type = Column(String(255), nullable=False)
    order_date = Column(String(255), nullable=False)
    channel = Column(String(255), nullable=False)
    source = Column(String(255), nullable=False)
    shipment_mode = Column(String(255), nullable=False)
    courier_partner = Column(String(255), nullable=True)
    delivery_partner = Column(String(255), nullable=True)
    company_id = Column(String(255), nullable=True)

    # payment
    payment_mode = Column(String(255), nullable=False)
    total_amount = Column(String(255), nullable=False)
    shipping_charges = Column(String(255), nullable=True)
    cod_charges = Column(String(255), nullable=True)
    tax_amount = Column(String(255), nullable=True)
    discount = Column(String(255), nullable=True)

    # invoice details
    invoice_number = Column(String(255), nullable=False)
    invoice_date = Column(String(255), nullable=False)
    invoice_amount = Column(String(255), nullable=False)
    invoice_url = Column(String(255), nullable=True)
    eway_bill_number = Column(String(255), nullable=True)
    eway_expire_date = Column(String(255), nullable=True)
    eway_distance = Column(String(255), nullable=True)

    # pickup details
    pickup_name = Column(String(255), nullable=False)
    pickup_phone = Column(String(255), nullable=False)
    pickup_email = Column(String(255), nullable=True)
    pickup_company = Column(String(255), nullable=True)
    pickup_address = Column(String(255), nullable=False)
    pickup_pincode = Column(String(255), nullable=False)
    pickup_city = Column(String(255), nullable=False)
    pickup_state = Column(String(255), nullable=False)
    pickup_country = Column(String(255), nullable=False)
    pickup_location_code = Column(String(255), nullable=True)

    # shipping details
    consignee_name = Column(String(255), nullable=False)
    consignee_phone = Column(String(255), nullable=False)
    consignee_email = Column(String(255), nullable=True)
    consignee_company = Column(String(255), nullable=False)
    consignee_address = Column(String(255), nullable=False)
    consignee_pincode = Column(String(255), nullable=False)
    consignee_city = Column(String(255), nullable=False)
    consignee_state = Column(String(255), nullable=False)
    consignee_country = Column(String(255), nullable=False)

    # billing details
    billing_name = Column(String(255), nullable=False)
    billing_email = Column(String(255), nullable=True)
    billing_phone = Column(String(255), nullable=False)
    billing_company = Column(String(255), nullable=False)
    billing_address = Column(String(255), nullable=False)
    billing_pincode = Column(String(255), nullable=False)
    billing_city = Column(String(255), nullable=False)
    billing_state = Column(String(255), nullable=False)
    billing_country = Column(String(255), nullable=False)

    # products
    products = Column(JSON, nullable=True)

    # courier
    awb_number = Column(String(255), nullable=True)

    # package
    package_details = Column(JSON, nullable=True)
    number_of_boxes = Column(String(255), nullable=False)

    status = Column(String(255), nullable=False)
    tracking_info = Column(JSON, nullable=True)
    manifest_url = Column(String(255), nullable=True)
    label_url = Column(String(255), nullable=True)
    invoice_url = Column(String(255), nullable=True)
    tracking_id = Column(String(255), nullable=True)

    def __to_model(self) -> Order_Model:
        return Order.model_validate(self)

    @classmethod
    def create_new_order(cls, order) -> Order_Model:
        from controller.context_manager import get_db_session

        db: Session = get_db_session()
        db.add(order)
        db.flush()
        return order

    @classmethod
    def get_order_by_id(cls, id) -> Order_Model:
        user = super().get_by_id(id)
        return user if user else None

    @classmethod
    def get_order_by_uuid(cls, uuid) -> Order_Model:
        user = super().get_by_uuid(uuid)
        return user if user else None
