import http
import json
import datetime
import requests
from urllib3.exceptions import InsecureRequestWarning
from psycopg2 import DatabaseError
import traceback
import certifi

from controller.context_manager import context_user_data
from controller.context_manager import get_db_session

from model.order import Order
from schema.base import GenericResponseModel
from schema.shipment import Shipment_create_model

from logger import logger


class Shipperfecto:

    @staticmethod
    def createOrder(shipment_details: Shipment_create_model):

        # print("1234567890")

        with get_db_session() as db:
            order = (
                db.query(Order)
                .filter(Order.order_id == shipment_details.order_id)
                .first()
            )

            order.status = "Booked"
            order.awb_number = "TEST_AWB"
            order.courier_partner = "Delhivery"

            new_tracking_info = {
                "event": "Delhivery Shipment Created",
                "subinfo": "delivery partner - Delhivery",
                "date": datetime.datetime.now().strftime("%d/%m/%Y %H:%M"),
            }

            track = order.tracking_info.copy()
            track.append(new_tracking_info)
            order.tracking_info = track

            db.add(order)
            db.commit()

        return GenericResponseModel(
            status_code=http.HTTPStatus.CREATED,
            data={
                "status": 1,
                "awb_number": "TEST_AWB",
                "courier_partner": "Delhivery",
                "delivery_partner": "Delhivery",
            },
            message="Shipment Successfully Created",
        )

        api_url = "https://app.shiperfecto.com/api/v1/create-order"

        body = {
            "order_id": shipment_details.order_id,
            "consignee_full_name": shipment_details.consignee_name,
            "consignee_primary_contact": shipment_details.consignee_phone,
            "consignee_email": shipment_details.consignee_email,
            "consignee_address1": shipment_details.consignee_address,
            "consignee_address2": shipment_details.consignee_address,
            "consignee_address_type": "-",
            "pincode": shipment_details.consignee_pincode,
            "city": shipment_details.consignee_city,
            "state": shipment_details.consignee_state,
            "invoice_number": shipment_details.invoice_number,
            "payment_mode": (
                "cod" if shipment_details.payment_mode == "COD" else "prepaid"
            ),
            "express_type": "surface",
            "products": [
                {
                    "product_name": product.name,
                    "product_qty": str(product.quantity),
                    "product_val": product.unit_price,
                    "product_sku": product.sku_code,
                }
                for product in shipment_details.products
            ],
            "order_amount": str(shipment_details.total_amount),
            "total_amount": str(shipment_details.total_amount),
            "cod_amount": (
                "1"
                if shipment_details.payment_mode == "COD"
                else str(shipment_details.cod_charges)
            ),
            "tax_amount": str(shipment_details.tax_amount),
            "order_weight": str(
                sum(float(obj.weight) for obj in shipment_details.package_details)
            ),
            "order_length": shipment_details.package_details[0].length,
            "order_width": shipment_details.package_details[0].breadth,
            "order_height": shipment_details.package_details[0].height,
            # "pickup_address_id": int(shipment_details.pickup_location_code),
            # "return_address_id": int(shipment_details.pickup_location_code),
            "pickup_address_id": 1970,
            "return_address_id": 1970,
            "delivery_partner": "delhivery",
            # 3568
        }

        try:

            headers = {
                "Authorization": "Token PfCk3KuCKTo8IzBtF1SuNl2mKm0lZ0QbOt3lEoha",
                "Content-Type": "application/json",
            }

            print("bebebebebebebebebebebebebebebe")

            # async with httpx.AsyncClient(verify=False) as client:
            #     response = await client.get(api_url, json=body, headers=headers)

            # response = requests.post(
            #     api_url, json=body, headers=headers, verify=False, timeout=10
            # )

            print("HIFUHDKJFHSDKJFSDKJFSDKJFDSKJF", response)

            try:
                response_data = response.json()  # Parse JSON response
            except ValueError as e:
                logger.error("Failed to parse JSON response: %s", e)
                return GenericResponseModel(
                    status_code=http.HTTPStatus.INTERNAL_SERVER_ERROR,
                    message="Invalid JSON response from the server.",
                )

            print("************************************")
            print(response_data)

            logger.log(
                extra=response_data,
                msg="response",
            )

            if response_data["status"] == True:
                with get_db_session() as db:
                    order = (
                        db.query(Order)
                        .filter(Order.order_id == shipment_details.order_id)
                        .first()
                    )

                    order.status = "Booked"
                    order.awb_number = response_data["order_data"]["awb"]
                    order.courier_partner = "shipperfecto"

                    new_tracking_info = {
                        "event": "Shipperfecto Shipment Created",
                        "subinfo": "deilvery partner - "
                        + response_data["order_data"]["delivery_partner"],
                        "date": datetime.datetime.now().strftime("%d/%m/%Y %H:%M"),
                    }

                    track = order.tracking_info.copy()
                    track.append(new_tracking_info)
                    order.tracking_info = track

                    db.add(order)
                    db.commit()

                return GenericResponseModel(
                    status_code=http.HTTPStatus.CREATED,
                    data={
                        "status": 1,
                        "awb_number": response_data["order_data"]["awb"],
                        "courier_partner": "shipperfecto",
                        "delivery_partner": response_data["order_data"][
                            "delivery_partner"
                        ],
                    },
                    message="Shipment Successfully Created",
                )

            else:
                return GenericResponseModel(
                    status_code=http.HTTPStatus.BAD_REQUEST,
                    message=response_data["order_data"]["error"],
                )

        except requests.exceptions.HTTPError as http_err:
            # Handle HTTP errors, such as 500 Internal Server Error
            logger.error("HTTP error occurred: %s", http_err)
            return GenericResponseModel(
                status_code=response.status_code,
                message=f"HTTP error occurred: {http_err}",
            )

        except requests.exceptions.RequestException as req_err:
            # Handle any other request exceptions, such as network errors
            logger.error("Request exception occurred: %s", req_err)
            return GenericResponseModel(
                status_code=http.HTTPStatus.INTERNAL_SERVER_ERROR,
                message="An error occurred while processing the request.",
            )

        except Exception as e:
            # Handle any other exceptions, including unexpected ones
            logger.error("An unexpected error occurred: %s", traceback.format_exc())
            return GenericResponseModel(
                status_code=http.HTTPStatus.INTERNAL_SERVER_ERROR,
                message="An unexpected error occurred. Please try again later.",
            )

    def track_shipment(awb_number: str):

        headers = {
            "Authorization": "Token PfCk3KuCKTo8IzBtF1SuNl2mKm0lZ0QbOt3lEoha",
            "Content-Type": "application/json",
        }

        api_url = "https://app.shiperfecto.com/api/v1/tracking?awb=" + awb_number

        response = requests.get(api_url, headers=headers, verify=False)
        response_data = response.json()

        tracking_data = response_data.get("tracking_data", "")

        if not tracking_data:
            return GenericResponseModel(
                status_code=http.HTTPStatus.BAD_REQUEST,
                message="Some error occurred, Please try again",
            )

        track_status = tracking_data.get("track_status", "")

        if track_status == 0:
            return GenericResponseModel(
                status_code=http.HTTPStatus.BAD_REQUEST,
                message=tracking_data.get(
                    "error", "Some error occured while tracking the shipment"
                ),
            )

        current_status = tracking_data["shipment_track"][0]["current_status"]
        updated_awb_number = tracking_data["shipment_track"][0]["awb_code"]

        activites = tracking_data["shipment_track_activities"]

        with get_db_session() as db:
            order = db.query(Order).filter(Order.awb_number == awb_number).first()

            order.status = current_status
            order.awb_number = updated_awb_number

            old_tracking_info = order.tracking_info[:2]

            if activites:
                new_tracking_info = [
                    {
                        "event": activity.get("sr-status-label", ""),
                        "subinfo": activity.get("activity", ""),
                        "date": activity.get("date", ""),
                        "location": activity.get("location", ""),
                    }
                    for activity in activites
                ]

                new_tracking_info.reverse()

                track = old_tracking_info + new_tracking_info
                order.tracking_info = track

            db.add(order)
            db.commit()

        return GenericResponseModel(
            status_code=http.HTTPStatus.OK,
            status=True,
            data={
                "awb_number": updated_awb_number,
                "current_status": current_status,
            },
            message="Tracking successfull",
        )
