import http
import json
import datetime
import requests
from psycopg2 import DatabaseError

from controller.context_manager import context_user_data
from controller.context_manager import get_db_session

from model.order import Order
from schema.base import GenericResponseModel
from schema.shipment import Shipment_create_model

from logger import logger


class Max_Logistics:

    @staticmethod
    def createOrder(shipment_details: Shipment_create_model):
        api_url = "http://www.maxpacific.net/Magix/rest/operation/wCNoteBook.htm"

        print("fkahdfkjadfkljahdkjahsdkfahskdjfhaksjdhfkjashfkajsdhf")
        print(shipment_details.package_details)

        body = {
            "compID": "MAXPACIFIC",
            "userID": "WEBTEST",
            "password": "W!@Test",
            "customerCode": "1340000220",
            "cNoteNo": "",
            "clientSecret": "06AABW45USA2A5EAEAAI98NICACQ32GAAB34",
            "BookingDetail": {
                "conorPincode": shipment_details.pickup_pincode,
                "conorName": shipment_details.pickup_company,
                "conorAddress1": shipment_details.pickup_address,
                "conorAddress2": "",
                "conorPerson": shipment_details.pickup_name,
                "conorMobile": shipment_details.pickup_phone,
                "conorEmail": shipment_details.pickup_email,
                "coneePincode": shipment_details.consignee_pincode,
                "coneeName": shipment_details.consignee_company,
                "coneeType": "WAREHOUSE",
                "coneeAddress1": shipment_details.consignee_address,
                "coneeAddress2": "",
                "coneePerson": shipment_details.consignee_name,
                "coneeMobile": shipment_details.consignee_phone,
                "coneeEmail": shipment_details.consignee_email,
                "paymentType": "TBB",
                "bookingType": "Express",
                "pickupDelivery": "Door To Door",
                "transitMode": "Road",
                "packageType": "Carton Box",
                "contentType": "General",
                "coddod": "",
                "codAmount": str(shipment_details.cod_charges),
                "totalBox": str(len(shipment_details.package_details)),
                "boxDetail": ",".join(
                    str(obj.box_id or "-") for obj in shipment_details.package_details
                ),
                "volType": "2",
                "dacc": "0",
                "refNo": "",
                "appDel": "0",
                "appTime": "19/01/2024 13:44",
                "frPaidToPay": "",
                "tripSheetNo": "",
                "stnNo": "",
                "dcCode": "",
                "reference1": "",
            },
            "InvoiceDetail": [
                {
                    "invoiceseq": "1",
                    "invoiceDate": "13/05/2024",
                    "invoiceNo": shipment_details.invoice_number,
                    "invoiceValue": str(
                        round(float(shipment_details.invoice_amount), 2)
                    ),
                    "noOfPackage": str(len(shipment_details.package_details)),
                    "actualWeight": str(
                        sum(
                            float(obj["weight"])
                            for obj in shipment_details.package_details
                        )
                    ),
                    "eWayBillNo": shipment_details.eway_bill_number,
                    "eWayExpireDate": "10/10/2024",
                    "ewayDistance": shipment_details.eway_distance,
                }
            ],
            "VolumetDetail": [
                {
                    "volseq": str(i + 1),
                    "cBox": str(i + 1),
                    "cLength": str((float(box.get("length", "")))),
                    "cWidth": str((float(box.get("breadth", "")))),
                    "cHeight": str((float(box.get("height", "")))),
                    "cWeight": str((float(box.get("weight", "")))),
                }
                for i, box in enumerate(shipment_details.package_details)
            ],
        }

        print(body)

        try:
            response = requests.post(api_url, json=body)
            response.raise_for_status()
            response_data = response.json()

            print(response_data)

            if response_data[0]["statusCode"] != "0":
                with get_db_session() as db:
                    order = (
                        db.query(Order)
                        .filter(Order.order_id == shipment_details.order_id)
                        .first()
                    )

                    order.status = "Booked"
                    order.awb_number = response_data[0]["DocketNo"]
                    order.courier_partner = "maxlogistics"
                    order.delivery_partner = "maxlogistics"

                    new_tracking_info = {
                        "event": "Max Pacific Shipment Created",
                        "date": datetime.datetime.now().strftime("%d/%m/%Y %H:%M"),
                    }

                    track = order.tracking_info.copy()
                    track.append(new_tracking_info)
                    order.tracking_info = track

                    db.add(order)
                    db.commit()

                return GenericResponseModel(
                    status_code=http.HTTPStatus.CREATED,
                    data={
                        "awb_number": response_data[0]["DocketNo"],
                        "courier_partner": "maxlogistics",
                        "delivery_partner": "maxlogistics",
                    },
                    message="Shipment Successfully Created",
                    status=True,
                )

            else:
                return GenericResponseModel(
                    status_code=http.HTTPStatus.BAD_REQUEST,
                    message=response_data[0]["Message"],
                )

        except DatabaseError as e:
            logger.error(
                extra=context_user_data.get(),
                msg="Error creating shipment: {}".format(str(e)),
            )

            # Return error response
            return GenericResponseModel(
                status_code=http.HTTPStatus.INTERNAL_SERVER_ERROR,
                message=str(e),
            )
