import http
import json
import datetime
import requests
from psycopg2 import DatabaseError

from controller.context_manager import context_user_data
from controller.context_manager import get_db_session

from model.order import Order
from schema.base import GenericResponseModel
from schema.shipment import Shipment_create_model

from logger import logger


class Gati:

    def createOrder(shipment_details: Shipment_create_model):

        with get_db_session() as db:
            order = (
                db.query(Order)
                .filter(Order.order_id == shipment_details.order_id)
                .first()
            )

            order.status = "Booked"
            order.awb_number = "TEST_AWB"
            order.courier_partner = "Gati"

            new_tracking_info = {
                "event": "Gati Shipment Created",
                "subinfo": "delivery partner - Gati",
                "date": datetime.datetime.now().strftime("%d/%m/%Y %H:%M"),
            }

            track = order.tracking_info.copy()
            track.append(new_tracking_info)
            order.tracking_info = track

            db.add(order)
            db.commit()

        return GenericResponseModel(
            status_code=http.HTTPStatus.CREATED,
            data={
                "status": 1,
                "awb_number": "TEST_AWB",
                "courier_partner": "Gati",
                "delivery_partner": "Gati",
            },
            message="Shipment Successfully Created",
        )

        api_url = "https://app.shiperfecto.com/api/v1/create-order"

        body = {
            "order_id": shipment_details.order_id,
            "consignee_full_name": shipment_details.consignee_name,
            "consignee_primary_contact": shipment_details.consignee_phone,
            "consignee_email": shipment_details.consignee_email,
            "consignee_address1": shipment_details.consignee_address,
            "consignee_address2": shipment_details.consignee_address,
            "consignee_address_type": "-",
            "pincode": shipment_details.consignee_pincode,
            "city": shipment_details.consignee_city,
            "state": shipment_details.consignee_state,
            "invoice_number": shipment_details.invoice_number,
            "payment_mode": (
                "cod" if shipment_details.payment_mode == "COD" else "prepaid"
            ),
            "express_type": "surface",
            "products": [
                {
                    "product_name": product.name,
                    "product_qty": str(product.quantity),
                    "product_val": product.unit_price,
                    "product_sku": product.sku_code,
                }
                for product in shipment_details.products
            ],
            "order_amount": str(shipment_details.total_amount),
            "total_amount": str(shipment_details.total_amount),
            "cod_amount": (
                "1"
                if shipment_details.payment_mode == "COD"
                else str(shipment_details.cod_charges)
            ),
            "tax_amount": str(shipment_details.tax_amount),
            "order_weight": str(
                sum(float(obj.weight) for obj in shipment_details.package_details)
            ),
            "order_length": shipment_details.package_details[0].length,
            "order_width": shipment_details.package_details[0].breadth,
            "order_height": shipment_details.package_details[0].height,
            # "pickup_address_id": int(shipment_details.pickup_location_code),
            # "return_address_id": int(shipment_details.pickup_location_code),
            "pickup_address_id": 1970,
            "return_address_id": 1970,
            "delivery_partner": "delhivery",
            # 3568
        }

        try:

            headers = {
                "Authorization": "Token PfCk3KuCKTo8IzBtF1SuNl2mKm0lZ0QbOt3lEoha",
                "Content-Type": "application/json",
            }

            response = requests.post(api_url, json=body, headers=headers, verify=True)
            response_data = response.json()

            print("************************************")
            print(response_data)

            logger.log(
                extra=response_data,
                msg="response",
            )

            if response_data["status"] == True:
                with get_db_session() as db:
                    order = (
                        db.query(Order)
                        .filter(Order.order_id == shipment_details.order_id)
                        .first()
                    )

                    order.status = "Booked"
                    order.awb_number = response_data["order_data"]["awb"]
                    order.courier_partner = "shipperfecto"

                    new_tracking_info = {
                        "event": "Shipperfecto Shipment Created",
                        "subinfo": "deilvery partner - "
                        + response_data["order_data"]["delivery_partner"],
                        "date": datetime.datetime.now().strftime("%d/%m/%Y %H:%M"),
                    }

                    track = order.tracking_info.copy()
                    track.append(new_tracking_info)
                    order.tracking_info = track

                    db.add(order)
                    db.commit()

                return GenericResponseModel(
                    status_code=http.HTTPStatus.CREATED,
                    data={
                        "status": 1,
                        "awb_number": response_data["order_data"]["awb"],
                        "courier_partner": "shipperfecto",
                        "delivery_partner": response_data["order_data"][
                            "delivery_partner"
                        ],
                    },
                    message="Shipment Successfully Created",
                )

            else:
                return GenericResponseModel(
                    status_code=http.HTTPStatus.BAD_REQUEST,
                    message=response_data["order_data"]["error"],
                )

        except DatabaseError as e:
            logger.error(
                extra=context_user_data.get(),
                msg="Error creating shipment: {}".format(str(e)),
            )

            # Return error response
            return GenericResponseModel(
                status_code=http.HTTPStatus.INTERNAL_SERVER_ERROR,
                message=str(e),
            )

        except Exception as e:
            return GenericResponseModel(
                status_code=http.HTTPStatus.INTERNAL_SERVER_ERROR,
                message=str(e),
            )
