import http
from fastapi import APIRouter, Depends, HTTPException
from pydantic import BaseModel
from fastapi import APIRouter, Depends

from controller.context_manager import build_request_context

from schema.base import GenericResponseModel
from schema.user import UserInsertModel, UserLoginModel

from service.user_service import UserService

from utils.helper import build_api_response

user_router = APIRouter(tags=["auth"])


class AccessKeyRequestModel(BaseModel):
    access_key: str


@user_router.post(
    "/signup", status_code=http.HTTPStatus.CREATED, response_model=GenericResponseModel
)
async def signup_user(user: UserInsertModel, _=Depends(build_request_context)):
    response: GenericResponseModel = UserService.signup_user(user=user)
    return build_api_response(response)


@user_router.post(
    "/login", status_code=http.HTTPStatus.OK, response_model=GenericResponseModel
)
async def login_user(
    user_login_request: UserLoginModel, _=Depends(build_request_context)
):
    response: GenericResponseModel = UserService.login_user(
        user_login_request=user_login_request
    )
    return build_api_response(response)


@user_router.post(
    "/generate-token",
    status_code=http.HTTPStatus.OK,
    response_model=GenericResponseModel,
)
async def generate_access_token(
    access_key_request: AccessKeyRequestModel, _=Depends(build_request_context)
):
    response: GenericResponseModel = UserService.generate_access_token(
        access_key_request=access_key_request
    )
    return build_api_response(response)


@user_router.post(
    "/gati_test",
    status_code=http.HTTPStatus.OK,
    response_model=GenericResponseModel,
)
async def generate_access_token(_=Depends(build_request_context)):
    response: GenericResponseModel = UserService.gati_test()
    return build_api_response(response)
