import http

from fastapi import APIRouter, Depends

from controller.context_manager import build_request_context

from schema.base import GenericResponseModel
from schema.shipment import Shipment_create_model

from utils.helper import build_api_response

from service.shipment_service import ShipmentService

shipment_router = APIRouter(prefix="/shipment", tags=["shipment"])


@shipment_router.post(
    "/create", status_code=http.HTTPStatus.CREATED, response_model=GenericResponseModel
)
async def post_shipment(
    shipment_details: Shipment_create_model, _=Depends(build_request_context)
):
    response: GenericResponseModel = ShipmentService.create_new_shipment(
        shipment_details=shipment_details, courier=shipment_details.courier_partner
    )
    return build_api_response(response)


@shipment_router.get(
    "/track/awb/{awb_number}",
    status_code=http.HTTPStatus.CREATED,
    response_model=GenericResponseModel,
)
async def track(awb_number: str, _=Depends(build_request_context)):
    response: GenericResponseModel = ShipmentService.track_shipment(
        awb_number=awb_number
    )
    return build_api_response(response)


@shipment_router.get(
    "/track_all",
    status_code=http.HTTPStatus.CREATED,
    response_model=GenericResponseModel,
)
async def track_all(_=Depends(build_request_context)):
    response: GenericResponseModel = ShipmentService.track_all(ShipmentService)
    return build_api_response(response)
